
(function(PLUGIN_ID) {
    "use strict";
    /******************************************************/
    // 設定画面でフィールドコードを選択式にする
    //  - せつめい
    //   pConf		プラグインの設定情報
    //   pCode		選択式にしたいフィールドのコードオブジェクト配列
    /******************************************************/
    function Plg_SelConfigCode(pConf, pCode) {
        // フォーム設計情報から対象フィールドを設定
        //  - kinton APIでフォーム設計情報取得
        //  - 取得したフィールドコードをセレクトボックスに表示
        kintone.api('/k/v1/form', 'GET', {'app':kintone.app.getId()}, function(resp){
            var result = resp['properties'];
            for ( var cnt in pCode ) {
                for ( var key in pCode[cnt] ) {
                    var elSelect = document.getElementById(key);			// 対象セレクトボックス
                    for ( var key2 in result ) {
                        var elOption = document.createElement('option');	// セレクトボックス中身
                        // [code]の場合：通常フィールド && 添付ファイルのフィールドコードだけ選択肢に表示する
                        if ( result[key2]['code'] && result[key2]['type'] == 'FILE') {
                            elOption.setAttribute('value', result[key2]['code']);
                            elOption.textContent = result[key2]['code'] ;
                            elSelect.appendChild( elOption );						// 選択式に
                        }
                        // [elementId]の場合：空白パーツ
                    }
                    //既に値が設定されている場合はフィールドに値を設定する
                    if (pConf){ $('#'+key).val( pConf[pCode[cnt][key]] ); }
                }
            }
        }, function(){console.log("失敗");});
    }



    // プラグインIDの設定
    var conf = kintone.plugin.app.getConfig(PLUGIN_ID);          
     
    //既に値が設定されている場合はフィールドに値を設定する
    if (conf){
        $('#videoplay_fieldcode').val(conf['videoplay_fieldcode']);
    }
    
    // 設定フィールドのSelectBox化
    var prmCode = [
            {'videoplay_fieldcode':'videoplay_fieldcode'},
    ];
    Plg_SelConfigCode(conf, prmCode); 
 
    //「保存する」ボタン押下時に入力情報を設定する
    $('#submit').click(function() {
        var config = [];
        var videoplay_fieldcode = $('#videoplay_fieldcode').val();   
                 
        if (videoplay_fieldcode ==""){
            alert("入力して下さい");
            return;
        }
        config['videoplay_fieldcode'] = videoplay_fieldcode;
        
        kintone.plugin.app.setConfig(config);
    });
     
    //「キャンセル」ボタン押下時の処理
    $('#cancel').click(function() {
            history.back();
    });

    
})(kintone.$PLUGIN_ID);