(function (PLUGIN_ID) {
    'use strict';
    
    function func_video_play(event){

        // プラグイン設定画面で設定されたフィールド名を取得する
        var config = kintone.plugin.app.getConfig(PLUGIN_ID);

        // 添付ファイルのファイルキーを取得(一番最初のファイルのみ)
        var record = event.record;
        var filekey = record[config['videoplay_fieldcode']]['value'][0].fileKey;

        // VIDEOタグに直接URLを挿入すると認証エラーになるので、ajax(XMLHttpRequest)を使ってGETを行う
        var apiurl = '/k/v1/file.json?fileKey=' + filekey;
        var xhr = new XMLHttpRequest();
        xhr.open('GET', apiurl, true);
        xhr.setRequestHeader('X-Requested-With' , 'XMLHttpRequest');    //これが無いとIE,FFがNG
        xhr.responseType = "blob";

        // レスポンスが返ってきたら、表示する
        xhr.onload = function() {
            
            //blobから動的URL生成
            var blob = xhr.response;
            var url = window.URL || window.webkitURL;
            var blob_url = url.createObjectURL(blob);
            
            // 添付ファイルのDOM要素を取得
            var elvideo = kintone.app.record.getFieldElement(config['videoplay_fieldcode']);

            // <video>を生成
            var video = document.createElement("video");
            video.src = blob_url;
            video.controls = true;
            video.autoplay = true;

            // メタデータ読み込み完了時に実行されるイベント
            video.addEventListener("loadedmetadata",function (e){
                // 親要素である添付ファイルの縦横サイズを変更
                var w = video.videoWidth;
                var h = video.videoHeight+20;
                elvideo.setAttribute('style', 'width: '+ w +'px; height: '+ h +'px');
            });
            
            // 先に画面に表示しておく
            elvideo.appendChild(video);
        }
        // サーバにリクエストを送る
        xhr.send();
        
		return event;
    }


    // 詳細画面を表示するタイミング
    // kintone.app.record.getFieldElementは、この時しか使えない(後は一覧画面)
    kintone.events.on(['app.record.detail.show'], func_video_play);
 
})(kintone.$PLUGIN_ID);